{ A modal dialog box to select what to read from the parameter file; state
  variables, parameters or both. }
unit ReloadDlg;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, 
  Buttons, ExtCtrls, Dialogs;

type
  TDlgReload = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    Bevel1: TBevel;
    MoDirections: TMemo;
    CbParams: TCheckBox;
    CbState: TCheckBox;
    procedure OKBtnClick(Sender: TObject);
    procedure CbParamsClick(Sender: TObject);
    procedure CbStateClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DlgReload: TDlgReload;

implementation

uses stypes, fileio, frontend, display;

{$R *.DFM}

// Reload the selected items from the parameter file
procedure TDlgReload.OKBtnClick(Sender: TObject);
var
   temppar: paramarray; // temporary parmeter array
   tempstat: statearray; // temporary state array
begin
  tempstat := stat;       // to get names and units
  temppar := par;         // to get names and units
 // Read data from  the parameter file and store in the temporary arrays
  ReadParamFile(paramfilename, modeldef.numparam, temppar, modeldef.numstate,
                 tempstat, Mainform.currentresid);
  if CbParams.Checked and CbState.Checked then // Reload params and states
   begin  // Copy values in the temporary array to the global variables
{    for i:= 1 to modeldef.numstate do
      begin
        stat[i].value := tempstat[i].value;
        stat[i].value := tempstat[i].holdconstant;
      end;
    for i:= 1 to modeldef.numparam do par[i].value := temppar[i].value;  }
    stat := tempstat;
    par := temppar;
    NeedToSavePar := False;
   end
  else if CbParams.Checked then   // Reload only the parameter values
     par := temppar
 //   for i:= 1 to modeldef.numparam do par[i].value := temppar[i].value
  else if CbState.Checked then   // Reload only the state variables
     stat := tempstat;
 // for i:=1 to modeldef.numstate do stat[i].value := tempstat[i].value
end;

procedure TDlgReload.CbParamsClick(Sender: TObject);
begin
 if cbParams.Checked  = true
 then fmDisplayData.cbParams.Checked := true
 else fmDisplayData.cbParams.Checked := false;
end;

procedure TDlgReload.CbStateClick(Sender: TObject);  
begin
 if cbState.Checked  = true
 then fmDisplayData.cbState.Checked := true
 else fmDisplayData.cbState.Checked := false;
end;

end.
